#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2001,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)91   1.358   src/csm/core/pm/InstallUtils.pm.perl, setup, csm_rameh, rameh_base 12/18/03 13:01:52
#
#--------------------------------------------------------------------------------

package InstallUtils;

#  please refer the to the package descriptions at the link below:
#  http://www.pok.ibm.com/afs/aix.kingston.ibm.com/project/csm/www/home.html#Development
#  this will get you started with the idea and intention of these changed packages.

use strict;

use Fcntl qw(:flock);
use File::Basename;
use File::Find;
use File::Path;    # Provides mkpath()

use ArchiveUtils;
use MessageUtils;
use NodeUtils;
use NetworkUtils;
use ServerUtils;

#--------------------------------------------------------------------------------

=head1    InstallUtils.pm.perl

=head2    Package Description

    This is a deprecated program module, please do not add to this file.

    Every entry in this file is a wrapper to a routine in another package.
    All are a part of the CSM/install product. This work was done to give
    order to the contents of the InstallUils.pm.perl package,  which had
    grown beyond a managable size.

    This file is useful for finding the new location of InstallUtils.pm.perl
    subroutines. Note that in some instances, the package name and the 
    subroutine name have both been changed, but this is not the norm; typically
    just the package name has been changed.

    Please don't use these wrappers in your code -  instead use the new names,
    so that we can eventually retire this file.  It would also be useful if,
    as you encounter old "InstallUtils->" subroutines in existing code, you
    replaced the calls with the new names -  assuming you have time to do so. 


=cut

#--------------------------------------------------------------------------------

=head2    Packages

    use strict;

=cut

#--------------------------------------------------------------------------------

=head1    Redirected Subroutines


=head2    Alphabetical list


=head3  CreateRandomName
    

    ServerUtils->CreateRandomName

=cut

sub CreateRandomName { shift; return ServerUtils->CreateRandomName(@_); }

#--------------------------------------------------------------------------------

=head3  MountAixCdrom
    

    ArchiveUtils->MountAixCdrom

=cut

sub MountAixCdrom { shift; return ArchiveUtils->MountAixCdrom(@_); }

#--------------------------------------------------------------------------------

=head3  SetAllowRequest
    

    NodeUtils->SetAllowRequest

=cut

sub SetAllowRequest { shift; return NodeUtils->SetAllowRequest(@_); }

#--------------------------------------------------------------------------------

=head3  SetControlFlag
    

    NodeUtils->SetControlFlag

=cut

sub SetControlFlag { shift; return NodeUtils->SetControlFlag(@_); }

#--------------------------------------------------------------------------------

=head3  SetMode
    

    NodeUtils->SetMode

=cut

sub SetMode { shift; return NodeUtils->SetMode(@_); }

#--------------------------------------------------------------------------------

=head3  append_logging
    

    MessageUtils->append_logging

=cut

sub append_logging { shift; return MessageUtils->append_logging(@_); }

#--------------------------------------------------------------------------------

=head3  backup_logfile
    

    MessageUtils->backup_logfile

=cut

sub backup_logfile { shift; return MessageUtils->backup_logfile(@_); }

#--------------------------------------------------------------------------------

=head3  chPerm
    

    NetworkUtils->chPerm

=cut

sub chPerm { shift; return NetworkUtils->chPerm(@_); }

#--------------------------------------------------------------------------------

=head3  checkDistroCopied
    

    ArchiveUtils->checkDistroCopied

=cut

sub checkDistroCopied { shift; return ArchiveUtils->checkDistroCopied(@_); }

#--------------------------------------------------------------------------------

=head3  checkForNotFound
    

    NodeUtils->checkForNotFound

=cut

sub checkForNotFound { shift; return NodeUtils->checkForNotFound(@_); }

#--------------------------------------------------------------------------------

=head3  checkHOMEforSSHperm
    

    NetworkUtils->checkHOMEforSSHperm

=cut

sub checkHOMEforSSHperm { shift; return NetworkUtils->checkHOMEforSSHperm(@_); }

#--------------------------------------------------------------------------------

=head3  checkRPMInstall
    

    ArchiveUtils->checkRPMInstall

=cut

sub checkRPMInstall { shift; return ArchiveUtils->checkRPMInstall(@_); }

#--------------------------------------------------------------------------------

=head3  checkRSReachability
    

    NetworkUtils->checkRSReachability

=cut

sub checkRSReachability { shift; return NetworkUtils->checkRSReachability(@_); }

#--------------------------------------------------------------------------------

=head3  check_valid_install_distros
    

    ArchiveUtils->check_valid_install_distros

=cut

sub check_valid_install_distros
{
    shift;
    ArchiveUtils->check_valid_install_distros(@_);
}

#--------------------------------------------------------------------------------

=head3  chkethup
    

    NetworkUtils->chkethup

=cut

sub chkethup { shift; return NetworkUtils->chkethup(@_); }

#--------------------------------------------------------------------------------

=head3  close_delete_file
    

    ServerUtils->close_delete_file

=cut

sub close_delete_file { shift; return ServerUtils->close_delete_file(@_); }

#--------------------------------------------------------------------------------

=head3  configureTftp
    

    NetworkUtils->configureTftp

=cut

sub configureTftp { shift; return NetworkUtils->configureTftp(@_); }

#--------------------------------------------------------------------------------

=head3  configureTftp_inetd
    

    NetworkUtils->configureTftp_inetd

=cut

sub configureTftp_inetd { shift; return NetworkUtils->configureTftp_inetd(@_); }

#--------------------------------------------------------------------------------

=head3  copyBinaries
    

    ServerUtils->copyBinaries

=cut

sub copyBinaries { shift; return ServerUtils->copyBinaries(@_); }

#--------------------------------------------------------------------------------

=head3  copyDistroCD
    

    ArchiveUtils->copyDistroCD

=cut

sub copyDistroCD { shift; return ArchiveUtils->copyDistroCD(@_); }

#--------------------------------------------------------------------------------

=head3  copyDistroPKGPATH
    

    ArchiveUtils->copyDistroPKGPATH

=cut

sub copyDistroPKGPATH { shift; return ArchiveUtils->copyDistroPKGPATH(@_); }

#--------------------------------------------------------------------------------

=head3  copy_csm_scripts
    

    ServerUtils->copy_csm_scripts

=cut

sub copy_csm_scripts { shift; return ServerUtils->copy_csm_scripts(@_); }

#--------------------------------------------------------------------------------

=head3  copy_rpm
    

    ArchiveUtils->copy_rpm

=cut

sub copy_rpm { shift; return ArchiveUtils->copy_rpm(@_); }

#--------------------------------------------------------------------------------

=head3  cpSSHFiles
    

    NetworkUtils->cpSSHFiles

=cut

sub cpSSHFiles { shift; return NetworkUtils->cpSSHFiles(@_); }

#--------------------------------------------------------------------------------

=head3  createRPMList
    

    ArchiveUtils->createRPMList

=cut

sub createRPMList { shift; return ArchiveUtils->createRPMList(@_); }

#--------------------------------------------------------------------------------

=head3  createRPMSdir
    

    ArchiveUtils->createRPMSdir

=cut

sub createRPMSdir { shift; return ArchiveUtils->createRPMSdir(@_); }

#--------------------------------------------------------------------------------

=head3  createRPMVersionListAlreadyInstalled
    

    ArchiveUtils->createRPMVersionListAlreadyInstalled

=cut

sub createRPMVersionListAlreadyInstalled
{
    shift;
    ArchiveUtils->createRPMVersionListAlreadyInstalled(@_);
}

#--------------------------------------------------------------------------------

=head3  createSMSConfig
    

    ServerUtils->createSMSConfig

=cut

sub createSMSConfig { shift; return ServerUtils->createSMSConfig(@_); }

#--------------------------------------------------------------------------------

=head3  createTftpUser
    

    NetworkUtils->createTftpUser

=cut

sub createTftpUser { shift; return NetworkUtils->createTftpUser(@_); }

#--------------------------------------------------------------------------------

=head3  create_nodemap_file
    

    ServerUtils->create_nodemap_file

=cut

sub create_nodemap_file { shift; return ServerUtils->create_nodemap_file(@_); }

#--------------------------------------------------------------------------------

=head3  create_rpm_list_to_copy
    

    ArchiveUtils->create_rpm_list_to_copy

=cut

sub create_rpm_list_to_copy
{
    shift;
    ArchiveUtils->create_rpm_list_to_copy(@_);
}

#--------------------------------------------------------------------------------

=head3  create_rpm_list_to_install
    

    ArchiveUtils->create_rpm_list_to_install

=cut

sub create_rpm_list_to_install
{
    shift;
    ArchiveUtils->create_rpm_list_to_install(@_);
}

#--------------------------------------------------------------------------------

=head3  determineMS
    

    NetworkUtils->determineMS

=cut

sub determineMS { shift; return NetworkUtils->determineMS(@_); }

#--------------------------------------------------------------------------------

=head3  display_opensrcLicence
    

    ArchiveUtils->display_opensrcLicence

=cut

sub display_opensrcLicence
{
    shift;
    return ArchiveUtils->display_opensrcLicence(@_);
}

#--------------------------------------------------------------------------------

=head3  export_csminstall
    

    NetworkUtils->export_csminstall

=cut

sub export_csminstall { shift; return NetworkUtils->export_csminstall(@_); }

#--------------------------------------------------------------------------------

=head3  findImagesInPath
    

    ArchiveUtils->findImagesInPath

=cut

sub findImagesInPath { shift; return ArchiveUtils->findImagesInPath(@_); }

#--------------------------------------------------------------------------------

=head3  findRpm
    

    ArchiveUtils->findRpm

=cut

sub findRpm { shift; return ArchiveUtils->findRpm(@_); }

#--------------------------------------------------------------------------------

=head3  findRpmInPath
    

    ArchiveUtils->findRpmInPath

=cut

sub findRpmInPath { shift; return ArchiveUtils->findRpmInPath(@_); }

#--------------------------------------------------------------------------------

=head3  findRpmInPath_java
    

    ArchiveUtils->findRpmInPath_java

=cut

sub findRpmInPath_java { shift; return ArchiveUtils->findRpmInPath_java(@_); }

#--------------------------------------------------------------------------------

=head3  genHex
    

    NetworkUtils->genHex

=cut

sub genHex { shift; return NetworkUtils->genHex(@_); }

#--------------------------------------------------------------------------------

=head3  getBaseDir
    

    ServerUtils->getBaseDir

=cut

sub getBaseDir { shift; return ServerUtils->getBaseDir(@_); }

#--------------------------------------------------------------------------------

=head3  getBladeStatus
    

    NodeUtils->getBladeStatus

=cut

sub getBladeStatus { shift; return NodeUtils->getBladeStatus(@_); }

#--------------------------------------------------------------------------------

=head3  get_CSMVersion
    

    NodeUtils->get_CSMVersion

=cut

sub get_CSMVersion { shift; return NodeUtils->get_CSMVersion(@_); }

#--------------------------------------------------------------------------------

=head3  get_DistributionName
    

    NodeUtils->get_DistributionName

=cut

sub get_DistributionName { shift; return NodeUtils->get_DistributionName(@_); }

#--------------------------------------------------------------------------------

=head3  get_DistributionVersion
    

    NodeUtils->get_DistributionVersion

=cut

sub get_DistributionVersion
{
    shift;
    return NodeUtils->get_DistributionVersion(@_);
}

#--------------------------------------------------------------------------------

=head3  getInstallDir
    

    ServerUtils->getInstallDir

=cut

sub getInstallDir { shift; return ServerUtils->getInstallDir(@_); }

#--------------------------------------------------------------------------------

=head3  get_OSDefs
    

    ServerUtils->get_OSDefs

=cut

sub get_OSDefs { shift; return ServerUtils->get_OSDefs(@_); }

#--------------------------------------------------------------------------------

=head3  get_OSName
    

    NodeUtils->get_OSName

=cut

sub get_OSName { shift; return NodeUtils->get_OSName(@_); }

#--------------------------------------------------------------------------------

=head3  get_PkgArchitecture
    

    ArchiveUtils->get_PkgArchitecture

=cut

sub get_PkgArchitecture { shift; return ArchiveUtils->get_PkgArchitecture(@_); }

#--------------------------------------------------------------------------------

=head3  getRPMSDir
    

    ArchiveUtils->getRPMSDir

=cut

sub getRPMSDir { shift; return ArchiveUtils->getRPMSDir(@_); }

#--------------------------------------------------------------------------------

=head3  getRPMVersionRelease
    

    ArchiveUtils->getRPMVersionRelease

=cut

sub getRPMVersionRelease
{
    shift;
    return ArchiveUtils->getRPMVersionRelease(@_);
}

#--------------------------------------------------------------------------------

=head3  getRealRPMSDir
    

    ArchiveUtils->getRealRPMSDir

=cut

sub getRealRPMSDir { shift; return ArchiveUtils->getRealRPMSDir(@_); }

#--------------------------------------------------------------------------------

=head3  getRecentVersionRpm
    

    ArchiveUtils->getRecentVersionRpm

=cut

sub getRecentVersionRpm { shift; return ArchiveUtils->getRecentVersionRpm(@_); }

#--------------------------------------------------------------------------------

=head3  getRemoteShell
    

    NetworkUtils->getRemoteShell

=cut

sub getRemoteShell { shift; return NetworkUtils->getRemoteShell(@_); }

#--------------------------------------------------------------------------------

=head3  getReqsNotSatisfied
    

    ArchiveUtils->getReqsNotSatisfied

=cut

sub getReqsNotSatisfied { shift; return ArchiveUtils->getReqsNotSatisfied(@_); }

#--------------------------------------------------------------------------------

=head3  getRequiredRpms
    

    ArchiveUtils->getRequiredRpms

=cut

sub getRequiredRpms { shift; return ArchiveUtils->getRequiredRpms(@_); }

#--------------------------------------------------------------------------------

=head3  getRootHomeDir
    

    NetworkUtils->getRootHomeDir

=cut

sub getRootHomeDir { shift; return NetworkUtils->getRootHomeDir(@_); }

#--------------------------------------------------------------------------------

=head3  getSetupRemoteShell
    

    NetworkUtils->getSetupRemoteShell

=cut

sub getSetupRemoteShell { shift; return NetworkUtils->getSetupRemoteShell(@_); }

#--------------------------------------------------------------------------------

=head3  getSetupKRB5
    

    NodeUtils->getSetupKRB5

=cut

sub getSetupKRB5 { shift; return NodeUtils->getSetupKRB5(@_); }

#--------------------------------------------------------------------------------

=head3  getUpdateDir
    

    ServerUtils->getUpdateDir

=cut

sub getUpdateDir { shift; return ServerUtils->getUpdateDir(@_); }

#--------------------------------------------------------------------------------

=head3  get_common_attrs
    

    NodeUtils->get_common_attrs

=cut

sub get_common_attrs { shift; return NodeUtils->get_common_attrs(@_); }

#--------------------------------------------------------------------------------

=head3  get_csminstall_pathVersion
    

    ArchiveUtils->get_csminstall_pathVersion

=cut

sub get_csminstall_pathVersion
{
    shift;
    ArchiveUtils->get_csminstall_pathVersion(@_);
}

#--------------------------------------------------------------------------------

=head3  get_definition_version
    

    ArchiveUtils->get_definition_version

=cut

sub get_definition_version
{
    shift;
    return ArchiveUtils->get_definition_version(@_);
}

#--------------------------------------------------------------------------------

=head3  get_lock
    

    ServerUtils->get_lock

=cut

sub get_lock { shift; return ServerUtils->get_lock(@_); }

#--------------------------------------------------------------------------------

=head3  getmacs_via_dsh
    

    NetworkUtils->getmacs_via_dsh

=cut

sub getmacs_via_dsh { shift; return NetworkUtils->getmacs_via_dsh(@_); }

#--------------------------------------------------------------------------------

=head3  get_management_server
    

    NetworkUtils->get_management_server

=cut

sub get_management_server
{
    shift;
    return NetworkUtils->get_management_server(@_);
}

#--------------------------------------------------------------------------------

=head3  get_osdefs_files
    

    ServerUtils->get_osdefs_files

=cut

sub get_osdefs_files { shift; return ServerUtils->get_osdefs_files(@_); }

#--------------------------------------------------------------------------------

=head3  get_pkgVersion
    

    ArchiveUtils->get_pkgVersion

=cut

sub get_pkgVersion { shift; return ArchiveUtils->get_pkgVersion(@_); }

#--------------------------------------------------------------------------------

=head3  get_pkgdefs
    

    ServerUtils->get_pkgdefs

=cut

sub get_pkgdefs { shift; return ServerUtils->get_pkgdefs(@_); }

#--------------------------------------------------------------------------------

=head3  get_pkgdefs_files
    

    ServerUtils->get_pkgdefs_files

=cut

sub get_pkgdefs_files { shift; return ServerUtils->get_pkgdefs_files(@_); }

#--------------------------------------------------------------------------------

=head3  get_script_list
    

    ServerUtils->get_script_list

=cut

sub get_script_list { shift; return ServerUtils->get_script_list(@_); }

#--------------------------------------------------------------------------------

=head3  get_target_nodes
    

    NodeUtils->get_target_nodes

=cut

sub get_target_nodes { shift; return NodeUtils->get_target_nodes(@_); }

#--------------------------------------------------------------------------------

=head3  get_uniqu_arry_elemnts
    

    ServerUtils->get_uniqu_arry_elemnts

=cut

sub get_uniqu_arry_elemnts
{
    shift;
    return ServerUtils->get_uniqu_arry_elemnts(@_);
}

#--------------------------------------------------------------------------------

=head3 groupNFSnodes

  NetworkUtils->groupNFSnodes

=cut

sub groupNFSnodes { shift; return NetworkUtils->groupNFSnodes(@_); }

#--------------------------------------------------------------------------------

=head3  inc_ip
    

    NetworkUtils->inc_ip

=cut

sub inc_ip { shift; return NetworkUtils->inc_ip(@_); }

#--------------------------------------------------------------------------------

=head3  initialize_status
    

    MessageUtils->initialize_status

=cut

sub initialize_status { shift; return MessageUtils->initialize_status(@_); }

#--------------------------------------------------------------------------------

=head3  installRequiredRpms
    

    ArchiveUtils->installRequiredRpms

=cut

sub installRequiredRpms { shift; return ArchiveUtils->installRequiredRpms(@_); }

#--------------------------------------------------------------------------------

=head3  installSSHFiles
    

    NetworkUtils->installSSHFiles

=cut

sub installSSHFiles { shift; return NetworkUtils->installSSHFiles(@_); }

#--------------------------------------------------------------------------------

=head3  invokeLAP
    

   ArchiveUtils->invokeLAP

=cut

sub invokeLAP { shift; return ArchiveUtils->invokeLAP(@_); }

#--------------------------------------------------------------------------------

=head3  isAutoupdateInstalled
    

    ServerUtils->isAutoupdateInstalled

=cut

sub isAutoupdateInstalled
{
    shift;
    return ServerUtils->isAutoupdateInstalled(@_);
}

#--------------------------------------------------------------------------------

=head3  makeSyncHash
    

    ServerUtils->makeSyncHash

=cut

sub makeSyncHash { shift; return ServerUtils->makeSyncHash(@_); }

#--------------------------------------------------------------------------------

=head3  make_config_file
    

    ServerUtils->make_config_file

=cut

sub make_config_file { shift; return ServerUtils->make_config_file(@_); }

#--------------------------------------------------------------------------------

=head3  make_node_list_file
    

    ServerUtils->make_node_list_file

=cut

sub make_node_list_file { shift; return ServerUtils->make_node_list_file(@_); }

#--------------------------------------------------------------------------------

=head3  make_script_lists
    

    ServerUtils->make_script_lists

=cut

sub make_script_lists { shift; return ServerUtils->make_script_lists(@_); }

#--------------------------------------------------------------------------------

=head3  name2list
    

    ServerUtils->name2list

=cut

sub name2list { shift; return ServerUtils->name2list(@_); }

#--------------------------------------------------------------------------------

=head3  nfsprobe
    

    NetworkUtils->nfsprobe

=cut

sub nfsprobe { shift; return NetworkUtils->nfsprobe(@_); }

#--------------------------------------------------------------------------------

=head3  parseRequire
    

    ArchiveUtils->parseRequire

=cut

sub parseRequire { shift; return ArchiveUtils->parseRequire(@_); }

#--------------------------------------------------------------------------------

=head3  post_csm_copy
    

    ServerUtils->post_csm_copy

=cut

sub post_csm_copy { shift; return ServerUtils->post_csm_copy(@_); }

#--------------------------------------------------------------------------------

=head3  release_lock
    

    ServerUtils->release_lock

=cut

sub release_lock { shift; return ServerUtils->release_lock(@_); }

#--------------------------------------------------------------------------------

=head3  restartTftp
    

    NetworkUtils->restartTftp

=cut

sub restartTftp { shift; return NetworkUtils->restartTftp(@_); }

#--------------------------------------------------------------------------------

=head3  returnSubdirectory
    

    ServerUtils->returnSubdirectory

=cut

sub returnSubdirectory { shift; return ServerUtils->returnSubdirectory(@_); }

#--------------------------------------------------------------------------------

=head3  rmNodesKnownHosts
    

    NetworkUtils->rmNodesKnownHosts

=cut

sub rmNodesKnownHosts { shift; return NetworkUtils->rmNodesKnownHosts(@_); }

#--------------------------------------------------------------------------------

=head3  search_copy_distro_rpms
    

    ArchiveUtils->search_copy_distro_rpms

=cut

sub search_copy_distro_rpms
{
    shift;
    ArchiveUtils->search_copy_distro_rpms(@_);
}

#--------------------------------------------------------------------------------

=head3  search_csm
    

    ArchiveUtils->search_csm

=cut

sub search_csm { shift; return ArchiveUtils->search_csm(@_); }

#--------------------------------------------------------------------------------

=head3  search_opensrc_prereqs
    

    ArchiveUtils->search_opensrc_prereqs

=cut

sub search_opensrc_prereqs
{
    shift;
    return ArchiveUtils->search_opensrc_prereqs(@_);
}

#--------------------------------------------------------------------------------

=head3  search_rpm_csminstall_path
    

    ArchiveUtils->search_rpm_csminstall_path

=cut

sub search_rpm_csminstall_path
{
    shift;
    ArchiveUtils->search_rpm_csminstall_path(@_);
}

#--------------------------------------------------------------------------------

=head3  secureFilePermissions
    

    NetworkUtils->secureFilePermissions

=cut

sub secureFilePermissions
{
    shift;
    return NetworkUtils->secureFilePermissions(@_);
}

#--------------------------------------------------------------------------------

=head3  setupAIXRSH
    

    NetworkUtils->setupAIXRSH

=cut

sub setupAIXRSH { shift; return NetworkUtils->setupAIXRSH(@_); }

#--------------------------------------------------------------------------------

=head3  setupLinuxRSH
    

    NetworkUtils->setupLinuxRSH

=cut

sub setupLinuxRSH { shift; return NetworkUtils->setupLinuxRSH(@_); }

#--------------------------------------------------------------------------------

=head3  setupRemoteShellforFullInstall
    

    NetworkUtils->setupRemoteShellforFullInstall

=cut

sub setupRemoteShellforFullInstall
{
    shift;
    NetworkUtils->setupRemoteShellforFullInstall(@_);
}

#--------------------------------------------------------------------------------

=head3  start_logging
    

    MessageUtils->start_logging

=cut

sub start_logging { shift; return MessageUtils->start_logging(@_); }

#--------------------------------------------------------------------------------

=head3  start_nfs
    

    NetworkUtils->start_nfs

=cut

sub start_nfs { shift; return NetworkUtils->start_nfs(@_); }

#--------------------------------------------------------------------------------

=head3  stop_logging
    

    MessageUtils->stop_logging

=cut

sub stop_logging { shift; return MessageUtils->stop_logging(@_); }

#--------------------------------------------------------------------------------

=head3  subnet
    

    NetworkUtils->subnet

=cut

sub subnet { shift; return NetworkUtils->subnet(@_); }

#--------------------------------------------------------------------------------

=head3  supportedSSHversion
    

    NetworkUtils->supportedSSHversion

=cut

sub supportedSSHversion { shift; return NetworkUtils->supportedSSHversion(@_); }

#--------------------------------------------------------------------------------

=head3  syncServers
    

    ServerUtils->syncServers

=cut

sub syncServers { shift; return ServerUtils->syncServers(@_); }

#--------------------------------------------------------------------------------

=head3  testVersion
    

    ArchiveUtils->testVersion

=cut

sub testVersion { shift; return ArchiveUtils->testVersion(@_); }

#--------------------------------------------------------------------------------

=head3  testvalidconsole
    

    NodeUtils->testvalidconsole

=cut

sub testvalidconsole { shift; return NodeUtils->testvalidconsole(@_); }

#--------------------------------------------------------------------------------

=head3  testvalidpowermethod
    

    NodeUtils->testvalidpowermethod

=cut

sub testvalidpowermethod { shift; return NodeUtils->testvalidpowermethod(@_); }

#--------------------------------------------------------------------------------

=head3  unexport_csminstall
    

    NetworkUtils->unexport_csminstall

=cut

sub unexport_csminstall { shift; return NetworkUtils->unexport_csminstall(@_); }

#--------------------------------------------------------------------------------

=head3  verifyTftp
    

    NetworkUtils->verifyTftp

=cut

sub verifyTftp { shift; return NetworkUtils->verifyTftp(@_); }

#--------------------------------------------------------------------------------

=head3  verify_dhcp
    

    NetworkUtils->verify_dhcp

=cut

sub verify_dhcp { shift; return NetworkUtils->verify_dhcp(@_); }

#--------------------------------------------------------------------------------

=head3  write_status
    

    MessageUtils->write_status

=cut

sub write_status { shift; return MessageUtils->write_status(@_); }

#--------------------------------------------------------------------------------

1;
